﻿// Plik specyfikacji klasy FeetInches.
#ifndef FEETINCHES_H
#define FEETINCHES_H

// Klasa FeetInches zawiera odległość
// lub wymiar wyrażony w stopach i calach.

class FeetInches
{
private:
  int feet;         // Zmienna zawierająca liczbę stóp
  int inches;       // Zmienna zawierająca liczbę cali
  void simplify();  // Funkcja zdefiniowana w pliku FeetInches.cpp
public:
  // Konstruktor
  FeetInches(int f = 0, int i = 0)
    { feet = f;
      inches = i;
      simplify(); }

  // Mutatory
  void setFeet(int f)
    { feet = f; }

  void setInches(int i)
    { inches = i;
      simplify(); }

  // Akcesory
  int getFeet() const
    { return feet; }

  int getInches() const
    { return inches; }

  // Funkcje przeciążonych operatorów
  FeetInches operator + (const FeetInches &); // Przeciążony operator +
  FeetInches operator - (const FeetInches &); // Przeciążony operator −
};

#endif
